<?php

class Livedb extends Plugin
{
	var $title = "Live race info";
	var $ver = "1.0";
	var $author = "Dmitri Lebedev";
	
	function __constructor()
	{
		if (!is_object($conn))
			return false;
		
		if (get_class($conn) !== "Connection")
			return false;
		
		$this->conn =& $conn;
		$this->plugin =& $conn->plugin;
		
		$names = explode(" ", $conn->dbProperties);
		
		foreach($names as $v)
			$conn->$v =& $this->$v;
	}
	
	function CBF_ISP_VER($data)
	{
		$this->LFSVersion = $data;
	}
	
	function CBF_ISP_STA($data)
	{
		$this->state = $data;
	}
	
	function CBF_ISP_VTN($data)
	{
		$this->connect[$data["UCID"]]["Vote"] = $data["Action"];
	}
	
	function CBF_TINY_VTC($data)
	{
		foreach($this->connect as $k => $v)
			$this->connect[$k]["Vote"] = VOTE_NONE;
	}
	
	function CBF_TINY_VTA($data)
	{
		$this->CBF_TINY_VTC($data);
	}
	
	function CBF_TINY_CLR($data)
	{
		$this->player = array();
	}
	
	function CBF_ISP_RST($data)
	{
		$names = explode(" ", "RaceLaps QualMins NumP Track Weather Wind");
		foreach($names as $v)
			$this->state[$v] = $data[$v];
			
		$this->conn->sendPacket(compPacket(array("Type" => ISP_TINY, "SubT" => TINY_SST, "ReqI" => 254)));
		
		$this->result = array();
		
		$names = array("NumStops", "LapsDone", "Penalty");
		
		foreach($this->player as $k => $v)
			foreach($names as $v2)
				$this->player[$k][$v2] = 0;
	}
	
	function CBF_ISP_NCN($data)
	{
		$this->connect[$data["UCID"]] = $data;
		$this->state["NumConns"]++;
	}
	
	function CBF_ISP_CNL($data)
	{
		foreach($this->player as $k => $v)
			if ($v["UCID"] == $data["UCID"])
				unset($this->player[$k]);

		unset($this->connect[$data["UCID"]]);
		$this->state["NumConns"]--;
	}
	
	function CBF_ISP_CPR($data)
	{
		foreach($this->player as $k => $v)
			if ($v["UCID"] == $data["UCID"] && $v["AI"] === false)
			{
				$this->player[$k]["PName"] = $data["PName"];
				$this->player[$k]["Plate"] = $data["Plate"];
			}
	}
				
	function CBF_ISP_NPL($data)
	{
		$PLID = $data["PLID"];
		$this->player[$PLID] = $data;
		$player =& $this->player[$PLID];
		
		$player["connect"] =& $this->connect[$PLID];
		
		$bitnames = array("female", "AI", "remote");
		
		for ($i = 0; $i < 3; $i++)
			$player[$bitnames[$i]] = $player["PType"] & pow(2, $i);
			
		$player["PitLane"] = 0;
	}
	
	function CBF_ISP_PLP($data)
	{
		$names = array("NumStops", "LapsDone", "Penalty");
		
		foreach($names as $v)
			$this->player[$data["PLID"]][$v] = 0;
			
		$this->player[$data["PLID"]]["PitLane"] = PITLANE_ENTER;
	}
	
	function CBF_ISP_PLL($data)
	{
		unset($this->player["PLID"]);
	}
	
	function CBF_ISP_LAP($data)
	{
		$player =& $this->player[$data["PLID"]];
		
		$vars = array("LapsDone", "Flags", "Penalty", "NumStops");
		
		foreach($vars as $v)
			$player[$v] = $data[$v];
	}
	
	function CBF_ISP_PIT($data)
	{
		$this->CBF_ISP_LAP($data);
	}
	
	function CBF_ISP_PLA($data)
	{
		$this->player[$data["PLID"]]["PitLane"] = $data["Fact"];
	}
	
	function CBF_ISP_CCH($data)
	{
		$this->player[$data["PLID"]]["Camera"] = $data["Camera"];
	}
	
	function CBF_ISP_PEN($data)
	{
		$this->player["Penalty"] = $data["NewPen"];
		$this->player["Reason"] = $data["Reason"];
	}
	
	function CBF_ISP_TOC($data)
	{
		$this->player[$data["PLID"]]["UCID"] = $data["NewUCID"];
		$this->player[$data["PLID"]]["connect"] =& $this->connect[$data["NewUCID"]];
	}
	
	function CBF_ISP_FIN($data)
	{
		$PLID = $data["PLID"];
		$player =& $this->player[$PLID];
		
		if (!isset($this->result[$PLID]))
			$this->result[$PLID] = array();
		
		$result =& $this->result[$PLID];
		
		$names = array("PLID", "TTime", "BTime", "NumStops", "Confirm", "LapsDone");
		
		foreach ($names as $v)
			$result[$v] = $data[$v];
		
		$result["UName"] = $player["connect"]["UName"];

		$result["PName"] = $player["PName"];
		$result["Plate"] = $player["Plate"];
		$result["penalty"] = $player["penalty"];

		$result["player"] =& $this->player[$PLID];


		$player["NumStops"] = $data["NumStops"];
	}
	
	function CBF_ISP_RES($data)
	{
		$PLID = $data["PLID"];
		$player =& $this->player[$PLID];
		
		if (!isset($this->result[$PLID]))
			$this->result[$PLID] = array();
		
		$result =& $this->result[$PLID];
		
		$names = array("PLID", "TTime", "BTime", "NumStops", "Confirm", "LapsDone", "UName", "PName", "Plate", "ResultNum", "PSeconds");
		
		foreach ($names as $v)
			$result[$v] = $data[$v];
		
		$result["penalty"] = $player["penalty"];
		$result["player"] =& $this->player[$PLID];
		$player["NumStops"] = $data["NumStops"];
	}
}